# HTTP Protocol Skill

Deep HTTP/1.1, HTTP/2, and HTTP/3 protocol expertise for web protocol implementation and compliance.

## Overview

This skill provides specialized capabilities for implementing, testing, and debugging HTTP protocol implementations across all major versions. It covers RFC compliance validation, performance optimization, and protocol-specific debugging.

## Key Features

- HTTP/1.1, HTTP/2, and HTTP/3 protocol expertise
- RFC compliance validation and testing
- HTTP/2 frame stream analysis and HPACK debugging
- Performance testing and optimization
- Chunked encoding and keep-alive debugging

## When to Use

- Implementing HTTP servers or clients
- Validating RFC compliance
- Debugging HTTP/2 frame issues
- Optimizing HTTP performance
- Generating server configurations

## Dependencies

- curl
- h2spec
- nghttp2
- quiche
