# Ink Component Generator Skill

Generate Ink (React for CLI) components for interactive terminal UIs.

## Overview

This skill generates React-based terminal UI components using Ink, enabling the creation of interactive CLI applications with familiar React patterns.

## When to Use

- Building terminal UIs with React
- Creating interactive CLI components
- Implementing stateful terminal interfaces
- Setting up Ink project structure

## Quick Start

```json
{
  "projectName": "my-tui",
  "components": [
    {
      "name": "SelectList",
      "type": "interactive",
      "props": ["items", "onSelect"]
    }
  ]
}
```

## Features

- React component generation
- Custom hooks for CLI
- Input handling
- Layout components
- Testing setup

## Integration with Processes

| Process | Integration |
|---------|-------------|
| tui-application-framework | Ink component setup |
| interactive-form-implementation | Input components |
| dashboard-monitoring-tui | Display components |
