---
name: instructional-video-production
description: Plan, record, edit, and produce instructional video content including screencasts, demonstrations, and talking-head videos
allowed-tools: Read, Grep, Write, Edit, Glob, Bash
---

# Instructional Video Production

Plan, record, edit, and produce instructional video content including screencasts, demonstrations, and talking-head videos.

## Overview

This skill enables production of effective instructional video content. It encompasses planning, recording, editing, and production of various video formats to support learning objectives and engage learners effectively.

## Capabilities

### Video Planning
- Write video scripts
- Create shot lists
- Plan visual elements
- Design learning sequences
- Estimate production time

### Recording Techniques
- Capture screencasts effectively
- Record talking-head videos
- Create demonstrations
- Manage audio quality
- Handle lighting setup

### Video Editing
- Edit footage efficiently
- Add graphics and annotations
- Include captions and subtitles
- Incorporate transitions
- Balance audio levels

### Production Management
- Manage production workflow
- Organize assets
- Ensure consistent quality
- Meet accessibility requirements
- Distribute effectively

## Usage Guidelines

### Production Process
1. Define learning objectives
2. Write scripts and outlines
3. Plan visual elements
4. Set up recording environment
5. Record footage
6. Edit and post-produce
7. Review and publish

### Recording Best Practices
- Use quality microphone
- Ensure adequate lighting
- Minimize background noise
- Maintain consistent framing
- Record in segments

### Editing Guidelines
- Keep videos concise
- Add visual cues and signaling
- Include captions/subtitles
- Maintain consistent pacing
- Export in appropriate formats

## Integration Points

### Related Processes
- E-Learning Course Authoring
- SAM Model Implementation
- Multimedia Learning Design

### Collaborating Skills
- multimedia-learning-design
- elearning-storyboarding
- accessibility-compliance-auditing

## References

- Video production best practices
- Screencasting guidelines
- Multimedia learning principles
- Video accessibility standards
