---
name: interactive-dashboard-builder
description: Skill for building interactive data dashboards
allowed-tools:
  - Bash
  - Read
  - Write
metadata:
  specialization: scientific-discovery
  domain: science
  category: Visualization
  skill-id: SK-SCIDISC-023
---

# Interactive Dashboard Builder Skill

## Purpose

Build interactive data dashboards for exploring datasets, communicating findings, and enabling stakeholder engagement.

## Capabilities

- Create interactive plots
- Build filter controls
- Link visualizations
- Enable data exploration
- Support multiple views
- Deploy dashboards

## Usage Guidelines

1. Define dashboard goals
2. Select visualizations
3. Add interactions
4. Link components
5. Test functionality
6. Deploy dashboard

## Process Integration

Works within scientific discovery workflows for:
- Data exploration
- Results communication
- Stakeholder engagement
- Real-time monitoring

## Configuration

- Dashboard frameworks
- Interaction types
- Deployment options
- Data connections

## Output Artifacts

- Interactive dashboards
- Deployed applications
- Configuration files
- Documentation
