---
name: interpretive-writing
description: Create accessible interpretive content for diverse audiences including labels, wall text, catalog essays, educational materials, and digital content
allowed-tools: Read, Grep, Write, Edit, Glob, WebFetch
---

# Interpretive Writing

Create accessible interpretive content for diverse audiences including labels, wall text, catalog essays, educational materials, and digital content.

## Overview

This skill enables the creation of engaging interpretive content for museums and cultural organizations. It encompasses writing for various formats and audiences, from object labels to scholarly catalogs, ensuring accessibility and engagement across diverse visitor populations.

## Capabilities

### Object Labels
- Write concise, engaging label copy
- Follow word count and reading level guidelines
- Balance scholarly accuracy with accessibility
- Include relevant context and significance
- Apply universal design principles

### Wall Text and Panels
- Develop section introductions
- Create thematic narratives
- Layer information for multiple audiences
- Integrate with visual design
- Ensure readability standards

### Catalog Essays
- Conduct scholarly research
- Develop analytical arguments
- Write for educated general audiences
- Follow publication standards
- Integrate illustrations and references

### Educational Materials
- Create age-appropriate content
- Develop hands-on activities
- Write teacher guides and curricula
- Design family programs
- Support self-guided experiences

## Usage Guidelines

### Writing Process
1. Research subject matter thoroughly
2. Identify target audiences
3. Determine format and constraints
4. Draft content iteratively
5. Review for accessibility and accuracy
6. Test with representative audiences

### Accessibility Standards
- Write at appropriate reading levels
- Use plain language principles
- Provide text alternatives
- Consider multilingual needs
- Ensure visual accessibility

### Style Guidelines
- Lead with engaging content
- Use active voice
- Avoid jargon and assumptions
- Connect to visitor experience
- Maintain consistent voice

## Integration Points

### Related Processes
- Exhibition Development Process
- Education Program Development Process
- Visitor Experience Design Process

### Collaborating Skills
- curatorial-research
- accessibility-compliance
- digital-engagement-strategy

## References

- AAM Excellence in Exhibition Label Writing
- Beverly Serrell's Exhibit Labels
- Plain Language Guidelines
- Universal design principles
