---
name: interview-facilitation
description: Conduct semi-structured interviews and moderate focus groups with rapport building, probing techniques, and group dynamics management
allowed-tools:
  - Read
  - Write
  - Edit
  - Grep
  - Glob
  - Bash
---

# Interview and Facilitation Skill

Conduct semi-structured interviews and moderate focus groups with professional facilitation techniques.

## Overview

The Interview and Facilitation skill enables conducting semi-structured interviews and moderating focus groups with rapport building, probing techniques, group dynamics management, and ethical practice for high-quality qualitative data collection.

## Capabilities

### Interview Technique
- Question design
- Rapport building
- Active listening
- Probing strategies
- Closure techniques

### Focus Group Moderation
- Group composition
- Discussion guide development
- Group dynamics management
- Participant engagement
- Conflict navigation

### Probing Methods
- Follow-up questions
- Clarification probes
- Elaboration prompts
- Challenge probes
- Silent probing

### Recording and Documentation
- Audio/video recording
- Note taking
- Transcription
- Field notes
- Quality assurance

### Ethical Practice
- Informed consent
- Confidentiality
- Sensitive topics
- Power dynamics
- Participant welfare

## Usage Guidelines

### When to Use
- Collecting qualitative data
- Exploring perspectives
- Understanding experiences
- Gathering stakeholder input
- Building theory

### Best Practices
- Prepare thoroughly
- Build genuine rapport
- Listen actively
- Probe appropriately
- Document carefully

### Integration Points
- Qualitative Analysis skill
- Ethnographic Research skill
- Research Ethics and IRB skill
- Mixed Methods Integration skill

## References

- In-Depth Interview Protocol process
- Focus Group Facilitation process
- Ethnographic Fieldwork process
- Qualitative Research Specialist agent
