---
name: investor-network-mapper
description: Maps co-investor relationships, syndication history, and network connections
allowed-tools:
  - Read
  - Write
  - Glob
  - Grep
  - Bash
  - WebFetch
metadata:
  specialization: venture-capital
  domain: business
  skill-id: vc-skill-002
---

# Investor Network Mapper

## Overview

The Investor Network Mapper skill provides comprehensive mapping and analysis of co-investor relationships, syndication history, and professional network connections. It enables VCs to identify syndication opportunities, understand competitive dynamics, and leverage relationship networks for deal flow and portfolio support.

## Capabilities

### Co-Investor Relationship Mapping
- Track historical co-investment patterns across funds and deals
- Analyze syndication frequency and deal-type preferences
- Identify preferred co-investor relationships and avoid lists
- Map fund-to-fund relationship strength

### Syndication History Analysis
- Maintain comprehensive database of syndicated deals
- Analyze check size patterns and stage preferences by investor
- Track lead vs. follow behavior patterns
- Identify emerging investor relationships and trends

### Network Connection Mapping
- Map professional networks of partners and associates
- LinkedIn integration for contact and relationship data
- Board seat network visualization
- Founder relationship tracking and introductions

### Relationship Intelligence
- Score relationship strength based on interaction history
- Identify warm introduction paths to targets
- Track relationship currency (favors, introductions, references)
- Monitor investor activity and fund deployment

## Usage

### Map Co-Investor Network
```
Input: Fund name or investor, analysis parameters
Process: Aggregate co-investment data, analyze patterns
Output: Network graph, relationship metrics, co-investor rankings
```

### Find Syndicate Partners
```
Input: Deal characteristics (stage, sector, geography, size)
Process: Match against investor preferences and history
Output: Ranked list of potential syndicate partners
```

### Identify Introduction Paths
```
Input: Target person or organization
Process: Search network graph for connection paths
Output: Recommended introduction paths, relationship strength
```

### Analyze Competitive Dynamics
```
Input: Competing fund or investor
Process: Map overlapping relationships and deal competition
Output: Competitive analysis, differentiation opportunities
```

## Integration Points

- **Deal Flow Tracker**: Source attribution and relationship ROI
- **Syndicate Manager (Agent)**: Provide network data for syndication
- **Proactive Deal Sourcing**: Identify warm introduction opportunities
- **Co-Investor Syndication Process**: Support partner selection

## Data Sources

- Proprietary deal database and CRM
- PitchBook, Crunchbase, CB Insights
- LinkedIn and professional networks
- SEC filings and public announcements
- Industry events and conferences

## Best Practices

1. Regularly update relationship data from deal activities
2. Track both successful and unsuccessful syndication attempts
3. Note relationship preferences and sensitivities
4. Maintain do-not-contact and competitor exclusion lists
5. Leverage relationship currency thoughtfully
