---
name: ipa-transcription-phonological
description: Transcribe speech using International Phonetic Alphabet and analyze sound systems including phonotactics and phonological rules
allowed-tools: Read, Grep, Write, Edit, Glob
---

# IPA Transcription and Phonological Analysis

Transcribe speech using International Phonetic Alphabet and analyze sound systems including phonotactics and phonological rules.

## Overview

This skill enables phonetic transcription and phonological analysis of language data. It encompasses IPA transcription, sound pattern analysis, and phonological rule identification for language documentation and linguistic research.

## Capabilities

### IPA Transcription
- Broad transcription
- Narrow transcription
- Diacritic usage
- Suprasegmental marking
- Consistency maintenance

### Phonemic Analysis
- Minimal pair identification
- Phoneme inventory
- Allophonic variation
- Complementary distribution
- Free variation

### Phonotactics
- Syllable structure
- Consonant clusters
- Vowel sequences
- Position constraints
- Morphophonemic patterns

### Phonological Rules
- Rule formalization
- Ordering constraints
- Feature analysis
- Process identification
- Exception handling

## Usage Guidelines

### Transcription Process
1. Listen to recording multiple times
2. Identify sound segments
3. Select appropriate IPA symbols
4. Mark prosodic features
5. Verify accuracy
6. Document conventions
7. Create clean transcription

### Analysis Approach
- Collect minimal pairs
- Identify phoneme inventory
- Analyze distribution patterns
- Formulate phonological rules
- Test against data

### Documentation Standards
- Use standard IPA
- Note transcription conventions
- Document speaker information
- Preserve recordings
- Maintain version control

## Integration Points

### Related Processes
- Phonetic and Phonological Analysis
- Language Documentation Project
- Corpus Linguistics Analysis

### Collaborating Skills
- morphosyntactic-analysis
- topic-modeling-text-mining
- research-ethics-irb-navigation

## References

- IPA Handbook
- Phonological analysis texts
- Language documentation standards
- Acoustic phonetics resources
