---
name: iso-implementation-guide
description: ISO 9001:2015 Quality Management System implementation skill with gap assessment and documentation templates
allowed-tools:
  - Read
  - Write
  - Glob
  - Grep
  - Edit
metadata:
  specialization: operations
  domain: business
  category: quality-management
---

# ISO Implementation Guide

## Overview

The ISO Implementation Guide skill provides comprehensive capabilities for implementing ISO 9001:2015 Quality Management Systems. It supports gap assessment, documentation generation, process procedure creation, and certification readiness assessment.

## Capabilities

- Gap assessment against ISO 9001:2015
- QMS documentation generation
- Process procedure templates
- Context of organization analysis
- Risk-based thinking integration
- Document control setup
- Management review facilitation
- Certification readiness assessment

## Used By Processes

- QMS-001: ISO 9001 Implementation
- QMS-003: Quality Audit Management
- CI-001: Operational Excellence Program Design

## Tools and Libraries

- QMS software
- Document management systems
- Audit management tools
- Training platforms

## Usage

```yaml
skill: iso-implementation-guide
inputs:
  organization_context:
    industry: "Manufacturing"
    size: "Medium"
    scope: "Design and manufacture of electronic components"
  current_state:
    existing_qms: false
    documented_processes: ["production", "purchasing"]
    certifications: []
  implementation_timeline: 12  # months
  target_certification: "ISO 9001:2015"
outputs:
  - gap_analysis
  - implementation_roadmap
  - document_templates
  - process_maps
  - risk_register
  - readiness_assessment
```

## ISO 9001:2015 Clause Structure

| Clause | Title | Requirements |
|--------|-------|--------------|
| 4 | Context of the Organization | Understanding context, interested parties, scope |
| 5 | Leadership | Leadership commitment, policy, roles |
| 6 | Planning | Risk/opportunities, objectives, planning changes |
| 7 | Support | Resources, competence, awareness, communication |
| 8 | Operation | Planning, design, production, delivery |
| 9 | Performance Evaluation | Monitoring, internal audit, management review |
| 10 | Improvement | Nonconformity, corrective action, continual improvement |

## Required Documented Information

### Mandatory Documents
- Quality policy
- Quality objectives
- Scope of QMS
- Process interactions

### Mandatory Records
- Competence records
- Design/development records
- Monitoring and measurement results
- Internal audit results
- Management review outputs
- Nonconformity and corrective actions

## Implementation Phases

### Phase 1: Foundation (Months 1-3)
1. Leadership commitment
2. Context analysis
3. Scope definition
4. Gap assessment

### Phase 2: Development (Months 4-6)
1. Process documentation
2. Risk assessment
3. Procedure creation
4. Training

### Phase 3: Implementation (Months 7-9)
1. Process deployment
2. Record collection
3. Internal audits
4. Corrective actions

### Phase 4: Certification (Months 10-12)
1. Management review
2. Pre-assessment audit
3. Certification audit
4. Continual improvement

## Integration Points

- Document management systems
- Training management systems
- Audit management platforms
- ERP systems
