---
name: klue-battlecards
description: Klue competitive enablement for dynamic battlecard management
allowed-tools:
  - Read
  - Write
  - Glob
  - Grep
  - Bash
  - WebFetch
metadata:
  specialization: sales
  domain: business
  priority: P1
  integration-points:
    - Klue API
---

# Klue Battlecards

## Overview

The Klue Battlecards skill provides integration with Klue's competitive enablement platform for dynamic battlecard access, compete alerts, sales feedback collection, and competitive positioning data. This skill empowers sales teams with real-time competitive intelligence at the point of need.

## Capabilities

### Dynamic Battlecards
- Access always-current battlecard content
- Surface context-relevant information
- Retrieve deal-specific positioning
- Handle multiple competitor comparisons

### Compete Alerts
- Receive real-time competitor updates
- Track competitive moves and announcements
- Monitor review site mentions
- Alert on pricing changes

### Sales Feedback Collection
- Capture field intelligence from sales
- Crowdsource competitive insights
- Validate and incorporate feedback
- Track feedback by source and type

### Competitive Positioning
- Access positioning frameworks
- Retrieve differentiation messaging
- Get competitive FAQ content
- Surface proof points and case studies

## Usage

### Deal Preparation
```
Retrieve competitive battlecard and recent alerts for competitors involved in an upcoming deal.
```

### Feedback Submission
```
Submit field intelligence gathered during customer conversations about competitor capabilities.
```

### Positioning Guidance
```
Get positioning recommendations for a specific competitive scenario or customer use case.
```

## Enhances Processes

- competitive-battle-cards
- challenger-sale-teaching

## Dependencies

- Klue subscription
- Battlecard content development
- Sales feedback workflow
