---
name: kwant-quantum-transport
description: Kwant quantum transport skill for mesoscopic physics, scattering matrix calculations, and nanostructure modeling
allowed-tools:
  - Bash
  - Read
  - Write
  - Edit
  - Glob
  - Grep
metadata:
  specialization: physics
  domain: science
  category: condensed-matter
  phase: 6
---

# Kwant Quantum Transport

## Purpose

Provides expert guidance on Kwant quantum transport calculations for mesoscopic systems, including scattering matrix computations and nanostructure modeling.

## Capabilities

- System builder for arbitrary geometries
- Scattering matrix computation
- Landauer-Buttiker formalism
- Tight-binding Hamiltonian construction
- Band structure visualization
- Parallel transport calculations

## Usage Guidelines

1. **System Definition**: Build systems with leads and scattering regions
2. **Hamiltonians**: Define tight-binding Hamiltonians
3. **Scattering**: Compute scattering matrices and conductance
4. **Band Structure**: Calculate and visualize band structures
5. **Parallelization**: Use parallel computing for large systems

## Tools/Libraries

- Kwant
- NumPy
- SciPy
