---
name: latex-document-compiler
description: Skill for compiling and managing LaTeX documents
allowed-tools:
  - Bash
  - Read
  - Write
metadata:
  specialization: scientific-discovery
  domain: science
  category: Communication
  skill-id: SK-SCIDISC-028
---

# LaTeX Document Compiler Skill

## Purpose

Compile and manage LaTeX documents including handling bibliographies, figures, and journal-specific templates.

## Capabilities

- Compile LaTeX documents
- Manage bibliographies
- Handle cross-references
- Apply journal templates
- Debug compilation errors
- Generate outputs

## Usage Guidelines

1. Set up document
2. Include dependencies
3. Configure compilation
4. Run compiler
5. Debug if needed
6. Generate output

## Process Integration

Works within scientific discovery workflows for:
- Manuscript preparation
- Thesis formatting
- Report generation
- Presentation creation

## Configuration

- Compiler selection
- Template management
- Bibliography style
- Output formats

## Output Artifacts

- Compiled PDFs
- Auxiliary files
- Error logs
- Output packages
