---
name: latex-math-formatter
description: High-quality LaTeX mathematical typesetting
allowed-tools:
  - Bash
  - Read
  - Write
  - Edit
  - Glob
  - Grep
metadata:
  specialization: mathematics
  domain: science
  category: documentation
  phase: 6
---

# LaTeX Math Formatter

## Purpose

Provides high-quality LaTeX mathematical typesetting capabilities for publication-ready documents.

## Capabilities

- Equation formatting and alignment
- Theorem environment generation
- Proof environment structuring
- AMS-LaTeX package utilization
- Cross-referencing management
- Bibliography generation (BibTeX)

## Usage Guidelines

1. **Environment Selection**: Use appropriate theorem/proof environments
2. **Equation Alignment**: Apply align environments for multi-line equations
3. **Numbering**: Consistent theorem and equation numbering
4. **Bibliography**: Proper BibTeX citation formatting

## Tools/Libraries

- LaTeX
- AMS packages
- Overleaf API
