---
name: latex-proof-formatter
description: Format proofs and algorithms in publication-quality LaTeX
allowed-tools:
  - Bash
  - Read
  - Write
  - Edit
  - Glob
  - Grep
metadata:
  specialization: computer-science
  domain: science
  category: research-documentation
  phase: 6
---

# LaTeX Proof Formatter

## Purpose

Provides expert guidance on formatting theoretical CS proofs and algorithms in publication-quality LaTeX.

## Capabilities

- Algorithm pseudocode formatting (algorithmicx)
- Inference rule typesetting
- Proof environment formatting
- Theorem numbering and cross-references
- BibTeX integration
- Conference style compliance

## Usage Guidelines

1. **Structure**: Organize proof structure clearly
2. **Algorithms**: Format algorithms with algorithmicx
3. **Rules**: Typeset inference rules with mathpartir
4. **References**: Manage cross-references properly
5. **Style**: Conform to conference/journal style

## Tools/Libraries

- LaTeX
- algorithmicx
- mathpartir
- amsthm
- Overleaf
