---
name: learning-analytics-interpretation
description: Analyze learner data from LMS reports, assessments, and engagement metrics to identify patterns and inform instructional decisions
allowed-tools: Read, Grep, Write, Edit, Glob, Bash, WebFetch
---

# Learning Analytics Interpretation

Analyze learner data from LMS reports, assessments, and engagement metrics to identify patterns and inform instructional decisions.

## Overview

This skill enables analysis and interpretation of learning data to improve educational outcomes. It encompasses data collection, pattern identification, visualization, and actionable insight generation to inform instructional and administrative decisions.

## Capabilities

### Data Analysis
- Analyze LMS activity data
- Interpret assessment results
- Examine engagement metrics
- Identify learning patterns
- Calculate performance indicators

### Pattern Identification
- Detect at-risk learners
- Identify successful behaviors
- Find correlation patterns
- Analyze cohort performance
- Track progress trends

### Visualization
- Create dashboards
- Design data visualizations
- Present trends clearly
- Compare across groups
- Track over time

### Actionable Insights
- Generate recommendations
- Prioritize interventions
- Inform course redesign
- Support learner feedback
- Guide resource allocation

## Usage Guidelines

### Analysis Process
1. Define analysis questions
2. Collect relevant data
3. Clean and prepare data
4. Apply analysis methods
5. Interpret findings
6. Generate recommendations
7. Communicate results

### Key Metrics
- Completion rates
- Time on task
- Assessment scores
- Engagement frequency
- Progress velocity

### Interpretation Guidelines
- Consider context
- Look for patterns over time
- Compare to benchmarks
- Account for confounding factors
- Validate with stakeholders

## Integration Points

### Related Processes
- Learning Analytics Implementation
- Kirkpatrick Evaluation
- Program Evaluation

### Collaborating Skills
- assessment-item-development
- lms-configuration-administration
- quality-assurance-review

## References

- Learning analytics frameworks
- Educational data mining methods
- xAPI and data standards
- Predictive analytics in education
