---
name: learning-needs-analysis
description: Conduct comprehensive learner audience analysis, identify performance gaps, and determine instructional requirements using surveys, interviews, and data analysis
allowed-tools: Read, Grep, Write, Edit, Glob, WebFetch
---

# Learning Needs Analysis

Conduct comprehensive learner audience analysis, identify performance gaps, and determine instructional requirements using surveys, interviews, and data analysis.

## Overview

This skill enables systematic analysis of learning needs to inform instructional design decisions. It encompasses audience analysis, performance gap identification, and requirements determination to ensure training and education programs address real needs effectively.

## Capabilities

### Audience Analysis
- Identify learner demographics and characteristics
- Assess prior knowledge and skills
- Determine learning preferences and styles
- Analyze motivation and attitudes
- Map learner contexts and constraints

### Performance Gap Analysis
- Define desired performance outcomes
- Assess current performance levels
- Identify gaps between current and desired states
- Distinguish training from non-training solutions
- Prioritize gaps by impact and feasibility

### Data Collection Methods
- Design and administer surveys
- Conduct stakeholder interviews
- Facilitate focus groups
- Analyze performance data
- Review existing documentation

### Requirements Documentation
- Document instructional requirements
- Define learning objectives
- Specify constraints and resources
- Identify success metrics
- Create analysis reports

## Usage Guidelines

### Analysis Process
1. Define scope and purpose of analysis
2. Identify data sources and stakeholders
3. Design data collection instruments
4. Collect and analyze data
5. Synthesize findings
6. Document recommendations

### Data Collection Best Practices
- Use multiple data sources
- Balance qualitative and quantitative methods
- Ensure representative sampling
- Maintain objectivity
- Validate findings with stakeholders

### Documentation Standards
- Clearly state methodology
- Present findings with evidence
- Distinguish facts from interpretations
- Provide actionable recommendations
- Include supporting data

## Integration Points

### Related Processes
- ADDIE Model Implementation
- Action Mapping
- Kirkpatrick Evaluation

### Collaborating Skills
- learning-objectives-writing
- assessment-item-development
- learning-analytics-interpretation

## References

- Mager and Pipe performance analysis
- Rossett needs assessment framework
- ATD competency model
- Instructional design methodologies
