---
name: learning-transfer-design
description: Design instructional strategies that promote knowledge and skill transfer to real-world application contexts
allowed-tools: Read, Grep, Write, Edit, Glob, WebFetch
---

# Learning Transfer Design

Design instructional strategies that promote knowledge and skill transfer to real-world application contexts.

## Overview

This skill enables design of instruction that promotes transfer of learning to workplace or real-world contexts. It encompasses transfer theory application, authentic learning design, and support system development to maximize learning impact.

## Capabilities

### Transfer Theory Application
- Apply near and far transfer principles
- Design for identical elements
- Create meaningful connections
- Support metacognitive development
- Build flexible knowledge structures

### Authentic Learning Design
- Create realistic scenarios
- Design workplace-like practice
- Use authentic assessments
- Incorporate real problems
- Simulate actual conditions

### Support System Design
- Design job aids and resources
- Create performance support tools
- Plan reinforcement strategies
- Develop manager involvement
- Build communities of practice

### Transfer Climate
- Address organizational barriers
- Build supervisor support
- Create accountability systems
- Provide application opportunities
- Track transfer outcomes

## Usage Guidelines

### Design Process
1. Analyze transfer context
2. Identify key transfer skills
3. Design authentic practice
4. Create support resources
5. Plan reinforcement
6. Measure transfer outcomes

### Transfer Strategies
- Use varied practice contexts
- Encourage reflection on application
- Build explicit connections
- Provide performance support
- Create accountability mechanisms

### Success Factors
- Relevance to job context
- Opportunity to apply
- Support from supervisors
- Reinforcement over time
- Removal of barriers

## Integration Points

### Related Processes
- Action Mapping
- Kirkpatrick Evaluation
- Gagne's Nine Events

### Collaborating Skills
- learning-needs-analysis
- facilitation-workshop-delivery
- learning-analytics-interpretation

## References

- Baldwin and Ford transfer model
- Broad and Newstrom transfer strategies
- Kirkpatrick and Kirkpatrick transfer
- Performance improvement research
