---
name: lessonly-training
description: Lessonly (Seismic Learning) training platform integration
allowed-tools:
  - Read
  - Write
  - Glob
  - Grep
  - Bash
  - WebFetch
metadata:
  specialization: sales
  domain: business
  priority: P2
  integration-points:
    - Lessonly API
---

# Lessonly Training

## Overview

The Lessonly Training skill provides integration with Lessonly (now Seismic Learning) for lesson assignment and tracking, practice recording review, certification management, and coaching feedback. This skill enables systematic sales training and skill development.

## Capabilities

### Lesson Management
- Assign lessons to learners
- Track lesson completion status
- Monitor quiz and assessment scores
- Handle lesson versioning

### Practice Recording
- Access practice recording submissions
- Review and score practice attempts
- Provide structured feedback
- Track improvement over time

### Certification Tracking
- Manage certification requirements
- Track certification status
- Handle recertification schedules
- Generate compliance reports

### Coaching Feedback
- Deliver feedback on performance
- Track coaching interactions
- Measure coaching impact
- Standardize coaching processes

## Usage

### Lesson Assignment
```
Assign a required training path to a new hire with appropriate deadlines and milestones.
```

### Practice Review
```
Review practice recordings for a team member and provide structured feedback for improvement.
```

### Certification Status
```
Check certification status across the team and identify compliance gaps requiring attention.
```

## Enhances Processes

- sales-methodology-training
- new-hire-onboarding-ramp

## Dependencies

- Lessonly/Seismic Learning subscription
- Lesson content development
- Recording infrastructure
