---
name: lessons-learned-repository
description: Capture, categorize, and retrieve project lessons learned for organizational learning
allowed-tools:
  - Read
  - Write
  - Glob
  - Grep
  - Bash
metadata:
  specialization: project-management
  domain: business
  category: Knowledge Management
  id: SK-018
---

# Lessons Learned Repository

## Overview

The Lessons Learned Repository skill provides comprehensive capabilities for capturing, categorizing, storing, and retrieving project lessons learned. It supports organizational learning by making past experiences searchable and actionable for current and future projects.

## Capabilities

### Lesson Capture
- Capture lessons using structured templates
- Support positive and negative lessons
- Document context, impact, and recommendations
- Link lessons to specific project phases and deliverables
- Capture lessons from retrospectives and reviews

### Categorization
- Categorize by project phase and knowledge area
- Tag by project type and industry
- Classify by outcome (success, failure, improvement)
- Link to root causes and contributing factors
- Associate with process areas and standards

### Search and Retrieval
- Search and retrieve relevant lessons for new projects
- Recommend applicable lessons based on project context
- Support full-text and faceted search
- Filter by relevance, recency, and applicability
- Generate lesson briefings for project teams

### Analysis and Reporting
- Generate lessons learned reports
- Analyze patterns across project history
- Calculate lesson implementation rate
- Identify recurring issues and successes
- Track lesson application outcomes

## Usage

### Input Requirements
- Lesson description and context
- Project and phase information
- Categorization attributes
- Recommendations and actions
- Optional: Supporting evidence and artifacts

### Output Deliverables
- Lessons learned register
- Search/retrieval results
- Pattern analysis report
- Recommended lessons for new projects
- Lessons implementation tracking

### Example Use Cases
1. **Project Closure**: Capture final lessons learned
2. **Project Kickoff**: Retrieve relevant historical lessons
3. **Process Improvement**: Analyze lesson patterns
4. **Training Development**: Compile lessons for training

## Process Integration

This skill integrates with the following processes:
- Lessons Learned and Knowledge Management
- Sprint Retrospective Facilitation
- benefits-realization.js
- Project Charter Development

## Dependencies

- Knowledge base infrastructure
- Search/retrieval engine
- Pattern analysis utilities
- Recommendation algorithms

## Related Skills

- SK-015: Retrospective Facilitator
- SK-008: Stakeholder Matrix Generator
- SK-011: Benefits Tracking Dashboard
