---
name: literary-close-reading
description: Perform systematic textual analysis identifying patterns in language, imagery, narrative structure, and rhetorical devices
allowed-tools: Read, Grep, Write, Edit, Glob
---

# Literary Close Reading

Perform systematic textual analysis identifying patterns in language, imagery, narrative structure, and rhetorical devices.

## Overview

This skill enables detailed literary analysis through close reading methods. It encompasses attention to language, imagery, structure, and rhetoric to develop interpretive insights about literary texts.

## Capabilities

### Language Analysis
- Diction examination
- Syntax patterns
- Tone identification
- Voice analysis
- Word choice significance

### Imagery and Figurative Language
- Metaphor analysis
- Simile identification
- Symbol interpretation
- Motif tracking
- Allusion recognition

### Narrative Structure
- Plot organization
- Point of view
- Temporal structure
- Framing devices
- Narrative progression

### Rhetorical Devices
- Persuasive techniques
- Argument structure
- Audience awareness
- Genre conventions
- Stylistic features

## Usage Guidelines

### Reading Process
1. Read text multiple times
2. Note initial observations
3. Identify patterns
4. Analyze specific passages
5. Connect observations
6. Develop interpretation
7. Support with evidence

### Analytical Focus Areas
- Opening and closing passages
- Repeated words and phrases
- Shifts in tone or perspective
- Unusual language choices
- Structural breaks or patterns

### Documentation Approach
- Quote significant passages
- Annotate observations
- Track patterns across text
- Note questions and puzzles
- Build interpretive arguments

## Integration Points

### Related Processes
- Close Reading Analysis
- Literary Theoretical Application
- Comparative Literature Analysis

### Collaborating Skills
- critical-theory-application
- citation-scholarly-apparatus
- tei-text-encoding

## References

- New Criticism methodology
- Close reading pedagogy
- Literary analysis guides
- Rhetorical analysis frameworks
