---
name: lms-configuration-administration
description: Configure learning management system settings, user roles, course templates, gradebooks, and third-party integrations
allowed-tools: Read, Grep, Write, Edit, Glob, Bash, WebFetch
---

# LMS Configuration and Administration

Configure learning management system settings, user roles, course templates, gradebooks, and third-party integrations.

## Overview

This skill enables effective administration of learning management systems. It encompasses system configuration, user management, course setup, gradebook configuration, and third-party integrations to support organizational learning needs.

## Capabilities

### System Configuration
- Configure platform settings
- Set up authentication methods
- Define organization hierarchy
- Customize branding and themes
- Manage notification settings

### User Management
- Create user roles and permissions
- Manage user accounts
- Configure enrollment methods
- Set up groups and cohorts
- Define user profiles

### Course Administration
- Create course templates
- Configure course settings
- Set up gradebooks
- Manage enrollment rules
- Design course catalogs

### Integration Management
- Configure SCORM/xAPI compliance
- Set up SIS integrations
- Implement SSO solutions
- Connect third-party tools
- Manage LTI connections

## Usage Guidelines

### Administration Process
1. Plan system configuration
2. Define user role structure
3. Create course templates
4. Configure gradebook settings
5. Set up integrations
6. Test and validate
7. Document procedures

### Configuration Best Practices
- Document all settings changes
- Test in staging environment
- Follow security best practices
- Maintain backup procedures
- Plan for scalability

### User Management
- Use role-based access control
- Implement least privilege principle
- Automate enrollment where possible
- Monitor user activity
- Maintain clean user data

## Integration Points

### Related Processes
- LMS Administration and Configuration
- SCORM/xAPI Package Development
- Learning Analytics Implementation

### Collaborating Skills
- learning-analytics-interpretation
- accessibility-compliance-auditing
- elearning-storyboarding

## References

- LMS vendor documentation
- SCORM and xAPI specifications
- LTI implementation guides
- EdTech integration standards
