# Log Analysis Skill

Structured log analysis and aggregation expertise for observability and troubleshooting.

## ID
SK-006

## Category
Observability

## Quick Reference

| Aspect | Details |
|--------|---------|
| Slug | `log-analysis` |
| Primary Use | Log parsing, querying, and pattern detection |
| Dependencies | Loki/ELK, log shippers |
| Process Integration | log-aggregation.js, monitoring-setup.js, incident-response.js |

## Key Capabilities

- **Log Parsing**: Handle JSON, syslog, and custom formats
- **Query Writing**: LogQL, Elasticsearch, Splunk SPL
- **Pattern Detection**: Identify anomalies and error clusters
- **Pipeline Config**: Configure log shipping and transformation
- **Alert Creation**: Build log-based alerting rules

## When to Use

Use this skill when you need to:
- Set up log aggregation systems
- Write complex log queries
- Analyze logs during incident response
- Configure log parsing pipelines
- Create log-based alerts

## Related

- **Skills**: prometheus-grafana (SK-003), incident-platforms (SK-014)
- **Agents**: observability-expert (AG-006), incident-commander (AG-007)
