---
name: logline-writing
id: SK-FTV-001
version: 1.0.0
description: Craft compelling one-sentence story hooks that capture protagonist, conflict, stakes, and unique appeal for film/TV pitches
specialization: film-tv-production
---

# Logline Writing Skill

## Purpose

Create compelling, marketable loglines that hook readers in a single sentence. A logline is the elevator pitch of your story—it must convey the essence of your narrative while creating intrigue and demonstrating commercial viability.

## Logline Formula

```
When [INCITING INCIDENT], a [SPECIFIC PROTAGONIST] must [GOAL/ACTION] before [STAKES/DEADLINE], or else [CONSEQUENCES].
```

### Core Components

| Element | Description | Example |
|---------|-------------|---------|
| Protagonist | Specific, relatable descriptor | "a burnt-out detective" |
| Inciting Incident | What disrupts their world | "discovers his partner was murdered" |
| Goal | Active, specific objective | "must find the killer" |
| Stakes | What's at risk | "before he becomes the next target" |
| Irony/Hook | The unique twist | "only to realize he's the prime suspect" |

## Quality Criteria

### Must Have
- Active protagonist (not passive victim)
- Clear goal with obstacles
- Tangible stakes
- Specific details (not generic)
- Present tense
- 25-50 words

### Must Avoid
- Character names (unless famous IP)
- Questions ("What if...?")
- Vague language ("must fight evil")
- Backstory dumps
- Multiple plotlines
- Passive voice

## Format Variations

### Punchy (Under 25 words)
```
A disgraced surgeon must perform an impossible transplant on a dying mob boss—using his own heart—to save his kidnapped daughter.
```

### Descriptive (40-60 words)
```
When a disgraced cardiac surgeon's daughter is kidnapped by a ruthless crime syndicate, he's forced to perform an impossible transplant: remove his own heart and transplant it into their dying boss. With only hours to live, he must find a way to save his daughter without sacrificing himself.
```

### High-Concept
```
"Saw" meets "Grey's Anatomy" - A surgeon must operate on himself to save his daughter from kidnappers.
```

## Genre-Specific Elements

### Action/Thriller
- Physical stakes
- Time pressure
- External threat
- Visceral verbs

### Drama
- Emotional stakes
- Internal conflict
- Relationship dynamics
- Transformation arc

### Comedy
- Comedic situation
- Fish-out-of-water
- Ironic juxtaposition
- Escalating complications

### Horror
- Survival stakes
- Atmosphere hint
- Threat nature
- Isolation element

## Output Format

```markdown
## Logline Package

### Primary Logline
[Main logline - 25-50 words]

### Variations

**Punchy Version:**
[Under 25 words]

**Descriptive Version:**
[40-60 words]

**High-Concept:**
[X meets Y format]

### Hook Analysis
- **Ironic Element:** [What makes this unique]
- **Genre Signals:** [How genre is conveyed]
- **Commercial Appeal:** [Why this is marketable]
```

## Examples by Format

### Feature Film
"When a retired hitman's dog is killed by mobsters, he comes out of retirement to wage a one-man war against the entire criminal underworld—discovering they've put a $14 million bounty on his head."

### TV Pilot
"A public defender discovers her new client—accused of a brutal murder—is actually her long-lost brother, forcing her to choose between her career and her family's darkest secrets."

### Limited Series
"After a small-town sheriff arrests a drifter for murder, she uncovers evidence that her entire town has been covering up crimes for decades—and her own father may be the mastermind."

### Short Film
"A grieving mother receives a phone call from her dead son, leading her to question whether she's losing her mind or being given a second chance."

## Best Practices

1. **Start with conflict** - The story is the struggle
2. **Be specific** - "Astronaut" not "person"
3. **Show stakes** - What's lost if they fail
4. **Create irony** - The unexpected twist
5. **Imply genre** - Through tone and situation
6. **End with hook** - Leave them wanting more
