---
name: lumerical-photonics-simulator
description: Lumerical FDTD and MODE skill for nanophotonics, integrated photonics, and solar cell design
allowed-tools:
  - Bash
  - Read
  - Write
  - Edit
  - Glob
  - Grep
metadata:
  specialization: physics
  domain: science
  category: optics-photonics
  phase: 6
---

# Lumerical Photonics Simulator

## Purpose

Provides expert guidance on Lumerical photonics simulations, including FDTD, eigenmode expansion, and integrated device design.

## Capabilities

- 2D/3D FDTD simulations
- Eigenmode expansion (EME)
- S-parameter extraction
- Grating coupler optimization
- CW and pulsed source analysis
- CHARGE electrical integration

## Usage Guidelines

1. **FDTD Setup**: Configure FDTD simulations for photonic structures
2. **Mode Analysis**: Use MODE for eigenmode calculations
3. **S-Parameters**: Extract S-parameters for circuit modeling
4. **Optimization**: Use built-in optimization tools
5. **Integration**: Combine optical and electrical simulations

## Tools/Libraries

- Lumerical FDTD
- MODE
- DEVICE
