---
name: lyric-writing
description: Write complete song lyrics with structural annotations and production notes optimized for AI music generation platforms like Suno and Udio
allowed-tools: Read, Write, Edit, WebSearch
id: SK-MAC-001
---

# Lyric Writing

Write complete, emotionally resonant song lyrics with detailed structural annotations and embedded production notes for AI music generation.

## Overview

This skill provides comprehensive lyric writing capabilities optimized for text-to-music AI platforms. It encompasses structural design, emotional mapping, hook development, and the embedding of production directions within the lyrics themselves.

## Capabilities

### Structural Composition
- Write complete verse-chorus-bridge structures
- Design pre-choruses and post-choruses
- Create intros, outros, and instrumental breaks
- Develop song sections with appropriate line counts
- Balance repetition and variation

### Production Annotations
- Embed delivery directions: `[whispered]`, `[spoken word]`, `[belt]`
- Include dynamics: `[building]`, `[soft]`, `[crescendo]`, `[fade]`
- Add vocal techniques: `[falsetto]`, `[raspy]`, `[breathy]`
- Note harmonies and layers: `[harmony]`, `[double-tracked]`
- Mark ad-lib sections: `[ad-lib]`, `[improvise]`

### Emotional Mapping
- Design emotional arcs within songs
- Create tension and release patterns
- Build to climactic moments
- Craft vulnerable, intimate sections
- Balance intensity throughout

### Hook Development
- Create memorable chorus hooks
- Design catchy phrase patterns
- Develop callback lines and motifs
- Craft earworm melodies through syllabics

### Voice Consistency
- Maintain artist persona throughout
- Match lyrical style to genre
- Keep thematic coherence
- Preserve character voice

## Usage Guidelines

### Annotation Standards
```
[Verse 1]
Opening lines that set the scene
[building] Lines that increase in intensity
[whispered] Intimate, soft delivery here

[Pre-Chorus]
[spoken word] Transition moment
Building tension toward chorus

[Chorus]
[belt] Main hook with power
Memorable, repeatable lines
[harmony] Layered vocal moment

[Bridge]
[falsetto] Vulnerable high notes
[raw] Emotionally exposed delivery

[Outro]
[fade] Final fading lines...
```

### Quality Checklist
- [ ] Clear structural markers for all sections
- [ ] Production notes embedded where needed
- [ ] Emotional arc mapped and intentional
- [ ] Hooks are memorable and repeatable
- [ ] Voice matches artist persona
- [ ] Syllable counts support melodic flow
- [ ] Rhyme scheme is intentional (tight or loose)

## Integration Points

### Related Skills
- SK-MAC-002 (style-specification) - Musical context for lyrics
- SK-MAC-004 (persona-development) - Voice and character
- SK-MAC-005 (album-conceptualization) - Thematic alignment

### Related Agents
- AG-MAC-001 (lyricist-agent) - Primary executor
- AG-MAC-005 (album-curator-agent) - Thematic guidance

## Output Format

```markdown
# [Song Title]

**Artist**: [Artist Name]
**Album**: [Album Name]
**Track**: [Number]

## Lyrics

[Intro]
...

[Verse 1]
...

[Chorus]
...

---

## Production Notes
- Key emotional moments: ...
- Dynamic range: ...
- Special directions: ...
```

## References

- Song structure theory and common forms
- AI music platform annotation best practices
- Emotional songwriting techniques
