---
name: mathematica-wolfram-interface
description: Interface with Mathematica/Wolfram Language for advanced symbolic computation
allowed-tools:
  - Bash
  - Read
  - Write
  - Edit
  - Glob
  - Grep
metadata:
  specialization: mathematics
  domain: science
  category: symbolic-computation
  phase: 6
---

# Mathematica/Wolfram Interface

## Purpose

Provides interface with Mathematica and Wolfram Language for advanced symbolic computation and mathematical analysis.

## Capabilities

- Wolfram Language evaluation
- Symbolic and numerical computation
- Special functions library access
- Pattern matching and rule-based transformation
- Visualization generation
- Wolfram Alpha natural language queries

## Usage Guidelines

1. **Expression Syntax**: Use Wolfram Language conventions
2. **Pattern Matching**: Apply rule-based transformations
3. **Function Library**: Access comprehensive special functions
4. **Visualization**: Generate publication-quality plots

## Tools/Libraries

- Wolfram Kernel
- Wolfram Alpha API
- Mathematica notebooks
