---
name: media-training-simulation
description: Media interview preparation and crisis simulation tools for executive readiness and spokesperson development
allowed-tools:
  - Read
  - Write
  - Glob
  - Grep
  - Bash
  - WebFetch
metadata:
  specialization: public-relations
  domain: business
  category: Crisis Communications
  skill-id: SK-013
---

# Media Training Simulation Skill

## Overview

The Media Training Simulation skill provides comprehensive tools for media interview preparation, crisis scenario simulation, and spokesperson development. This skill enables PR teams to prepare executives and spokespeople for media interactions through realistic simulations, structured feedback, and best practice training.

## Capabilities

### Interview Simulation
- Realistic interview scenario generation
- Multiple interview format simulations (print, broadcast, podcast)
- Hostile question preparation
- Live vs. taped interview practice
- Remote interview technical preparation

### Question Bank Management
- Categorized question library
- Difficulty level classification
- Topic-specific question sets
- Curveball and ambush question preparation
- Industry-specific question templates

### Video Recording and Review
- Interview recording management
- Side-by-side comparison tools
- Progress tracking over time
- Best practice video examples
- Performance annotation capabilities

### Message Bridge Technique Training
- Bridge statement templates
- Pivot technique instruction
- Key message reinforcement training
- Blocking and bridging practice
- Flagging technique development

### Body Language Feedback
- Non-verbal communication assessment
- Eye contact and posture guidance
- Gesture appropriateness evaluation
- Voice modulation coaching
- Stress indicator identification

### Crisis Scenario Simulation
- Crisis scenario library management
- Escalating complexity simulations
- Multi-stakeholder crisis scenarios
- Real-time pressure simulation
- Decision point analysis

### Tabletop Exercise Facilitation
- Exercise scenario development
- Facilitation guide generation
- Role assignment management
- Decision tracking and logging
- After-action report production

### Performance Assessment
- Scoring rubric application
- Competency-based evaluation
- Improvement tracking
- Certification readiness assessment
- Comparative benchmarking

## Integration Points

### Process Integration
- media-interview-preparation.js - All phases
- crisis-simulation-training.js - All phases
- executive-visibility-program.js - Training phases

### Skill Dependencies
- SK-003: Media Database (journalist research)
- SK-005: Crisis Management Platform (crisis scenarios)

### Agent Integration
- AG-006: Executive Visibility Expert (primary)
- AG-003: Crisis Communications Expert (crisis simulations)
- AG-001: Media Relations Strategist (media context)

## Usage

### Interview Preparation
```
Invoke media-training-simulation skill to:
1. Generate interview simulation for upcoming media briefing
2. Create question bank for product launch announcement
3. Conduct mock interview with performance feedback
```

### Crisis Training
```
Invoke media-training-simulation skill to:
1. Design crisis simulation tabletop exercise
2. Generate escalating crisis scenarios
3. Facilitate crisis response drill with scoring
```

### Ongoing Development
```
Invoke media-training-simulation skill to:
1. Track spokesperson skill development
2. Identify areas needing improvement
3. Generate personalized training plan
```

## Configuration

### Required Integrations
- Video conferencing APIs (Zoom, Teams, Webex)
- Learning management system connections
- Video storage and playback platforms

### Optional Integrations
- AI-powered analysis tools
- Speech analysis software
- Presentation feedback tools
- Calendar and scheduling systems

## Training Modules

### Foundational Training
1. Media landscape orientation
2. Key message development
3. Basic interview techniques
4. On-camera presence

### Advanced Training
1. Hostile interview management
2. Crisis communication tactics
3. Multi-format preparation
4. Executive presence refinement

### Specialized Training
1. Financial media interviews
2. Technical subject simplification
3. International media considerations
4. Social media live interactions

## Assessment Criteria

### Message Delivery
- Key message hit rate
- Consistency across responses
- Clarity and conciseness
- Proof point utilization

### Interview Technique
- Question handling
- Bridge utilization
- Time management
- Recovery from difficult moments

### Presence and Delivery
- Confidence projection
- Authenticity
- Audience connection
- Stress management

## Best Practices

1. Practice regularly, not just before interviews
2. Record all practice sessions for review
3. Simulate realistic pressure conditions
4. Focus on improvement areas identified in feedback
5. Update question banks with current issues
6. Include diverse interviewer styles in training
7. Debrief thoroughly after real interviews

---

**Version**: 1.0.0
**Created**: 2026-01-24
**Status**: Active
