---
name: medical-coding-audit
description: Review clinical documentation and assigned codes for accuracy, compliance, and optimization, identifying documentation improvement opportunities and coding errors
allowed-tools: Read, Grep, Write, Edit, Glob, WebFetch
---

# Medical Coding Audit

Review clinical documentation and assigned codes for accuracy, compliance, and optimization, identifying documentation improvement opportunities and coding errors.

## Overview

This skill enables auditing of medical coding accuracy and compliance. It encompasses documentation review, code validation, error identification, and improvement recommendations to ensure accurate reimbursement and regulatory compliance.

## Capabilities

### Code Review
- ICD-10-CM/PCS validation
- CPT/HCPCS verification
- Modifier appropriateness
- Sequencing accuracy
- Specificity assessment

### Documentation Analysis
- Clinical support review
- Query identification
- Documentation gaps
- Clarity assessment
- Medical necessity

### Compliance Validation
- Coding guidelines adherence
- Payer rules compliance
- Fraud and abuse screening
- Audit trail review
- Regulatory requirements

### Error Identification
- Upcoding detection
- Unbundling identification
- Missing charges
- Incorrect modifiers
- Sequencing errors

## Usage Guidelines

### Audit Process
1. Select audit sample
2. Review documentation
3. Validate code assignments
4. Identify discrepancies
5. Document findings
6. Calculate accuracy rates
7. Provide recommendations

### Audit Types
- Pre-bill audits
- Post-payment audits
- Focused audits
- Random sampling
- Targeted reviews

### Documentation Standards
- Detailed audit worksheets
- Finding classifications
- Trend analysis
- Education recommendations
- Follow-up tracking

## Integration Points

### Related Processes
- Medical Coding Compliance
- Clinical Documentation Improvement
- Claims Management Workflow

### Collaborating Skills
- clinical-documentation-query
- revenue-cycle-analytics
- regulatory-compliance-assessment

## References

- ICD-10-CM Official Guidelines
- CPT coding guidelines
- CMS coding policies
- OIG compliance guidance
