# Memory Analysis Skill

Embedded memory analysis, optimization, and leak detection.

## Purpose

Provides comprehensive memory analysis capabilities:
- Linker map file analysis
- Stack usage analysis and estimation
- Heap fragmentation detection
- Memory optimization strategies
- Memory protection configuration

## Key Features

- Map file parsing and analysis
- Static and dynamic stack analysis
- Heap allocation tracking
- Section optimization
- Memory region utilization
- MPU configuration support

## Integration

Used by processes requiring memory expertise:
- Memory architecture planning
- Code size optimization
- Execution speed profiling
- Bootloader implementation

## Dependencies

- Linker map file parsers
- Stack analysis tools (Puncover)
- objdump, readelf, nm utilities
