---
name: merger-model-builder
description: M&A merger model construction skill with accretion/dilution analysis and synergy modeling
allowed-tools:
  - Read
  - Write
  - Glob
  - Grep
  - Bash
metadata:
  specialization: finance-accounting
  domain: business
  category: investment-analysis
  priority: medium
---

# Merger Model Builder

## Overview

The Merger Model Builder skill creates comprehensive merger models for M&A transaction analysis. It enables purchase price allocation, accretion/dilution analysis, and pro forma financial modeling for deal evaluation.

## Capabilities

### Purchase Price Allocation
- Fair value determination
- Asset identification
- Liability assumption
- Intangible asset valuation
- Contingent consideration
- Working capital adjustments

### Goodwill Calculation
- Purchase consideration
- Fair value of net assets
- Bargain purchase assessment
- Measurement period adjustments
- Allocation documentation
- Impairment considerations

### Accretion/Dilution Analysis
- Pro forma EPS calculation
- Standalone EPS comparison
- Breakeven synergy analysis
- Sensitivity tables
- Year-by-year analysis
- Cash vs. stock consideration impact

### Synergy Modeling
- Revenue synergy identification
- Cost synergy quantification
- Phase-in timing
- Integration cost estimation
- Run-rate calculation
- Synergy NPV analysis

### Pro Forma Financials
- Combined income statement
- Combined balance sheet
- Combined cash flow statement
- Financing adjustments
- Transaction accounting
- Stub period handling

### Contribution Analysis
- Revenue contribution
- EBITDA contribution
- Net income contribution
- Ownership percentage
- Value creation allocation
- Exchange ratio analysis

## Usage

### Deal Evaluation
```
Input: Acquirer and target financials, deal terms, synergy assumptions
Process: Build pro forma model, analyze accretion/dilution
Output: Merger analysis, contribution metrics, board presentation
```

### Deal Structuring
```
Input: Valuation targets, EPS constraints, financing capacity
Process: Optimize consideration mix, model scenarios
Output: Recommended deal structure, sensitivity analysis
```

## Integration

### Used By Processes
- M&A Financial Due Diligence
- Comparable Company Analysis
- Discounted Cash Flow (DCF) Valuation

### Tools and Libraries
- Financial modeling templates
- Deal structuring tools
- Purchase accounting modules

## Best Practices

1. Align accounting treatment with deal structure
2. Build flexibility for multiple scenarios
3. Model synergies conservatively
4. Include integration costs realistically
5. Sensitivity test key assumptions
6. Document all adjustments and sources
