---
name: meta-analysis-engine
description: Skill for conducting meta-analyses of research findings
allowed-tools:
  - Bash
  - Read
  - Write
metadata:
  specialization: scientific-discovery
  domain: science
  category: Data Analysis
  skill-id: SK-SCIDISC-018
---

# Meta-Analysis Engine Skill

## Purpose

Conduct meta-analyses to synthesize effect sizes across studies and estimate pooled effects with heterogeneity assessment.

## Capabilities

- Extract effect sizes
- Calculate pooled estimates
- Assess heterogeneity
- Perform subgroup analyses
- Generate forest plots
- Evaluate publication bias

## Usage Guidelines

1. Extract study data
2. Calculate effect sizes
3. Pool estimates
4. Assess heterogeneity
5. Perform subgroup analyses
6. Evaluate bias

## Process Integration

Works within scientific discovery workflows for:
- Systematic reviews
- Evidence synthesis
- Research summarization
- Effect estimation

## Configuration

- Effect size metrics
- Pooling methods
- Heterogeneity tests
- Visualization options

## Output Artifacts

- Pooled estimates
- Forest plots
- Heterogeneity statistics
- Bias assessments
