---
name: metadata-standards-implementation
description: Apply Dublin Core, METS, MODS, and other metadata schemas for digital collections and archival materials
allowed-tools: Read, Grep, Write, Edit, Glob, Bash
---

# Metadata Standards Implementation

Apply Dublin Core, METS, MODS, and other metadata schemas for digital collections and archival materials.

## Overview

This skill enables professional metadata creation for digital collections. It encompasses schema selection, metadata creation, and standards implementation to ensure discoverability and interoperability of digital humanities resources.

## Capabilities

### Metadata Schemas
- Dublin Core elements
- METS structure
- MODS description
- EAD encoding
- Schema.org vocabularies

### Metadata Creation
- Element selection
- Value assignment
- Controlled vocabulary use
- Authority control
- Quality assurance

### Interoperability
- Crosswalks development
- Harvesting support
- Linked data principles
- API exposure
- Format conversion

### Quality Control
- Completeness checking
- Consistency verification
- Accuracy validation
- Standards compliance
- Enhancement planning

## Usage Guidelines

### Implementation Process
1. Analyze collection needs
2. Select appropriate schemas
3. Develop local guidelines
4. Create metadata records
5. Validate against standards
6. Enable interoperability
7. Maintain quality

### Schema Selection Criteria
- Collection type
- User needs
- System requirements
- Interoperability goals
- Resource constraints

### Quality Standards
- Complete required fields
- Use controlled vocabularies
- Follow local guidelines
- Maintain consistency
- Enable discovery

## Integration Points

### Related Processes
- Digital Archive Development
- Data Visualization for Cultural Research
- Spatial Humanities Mapping

### Collaborating Skills
- tei-text-encoding
- archival-finding-aid-interpretation
- gis-mapping-humanities

## References

- Dublin Core documentation
- Library of Congress standards
- Digital preservation guidelines
- Metadata best practices
