---
name: multimedia-learning-design
description: Apply Mayer's multimedia learning principles to design effective audio, video, graphics, and animations that reduce cognitive load
allowed-tools: Read, Grep, Write, Edit, Glob, WebFetch
---

# Multimedia Learning Design

Apply Mayer's multimedia learning principles to design effective audio, video, graphics, and animations that reduce cognitive load.

## Overview

This skill enables the design of effective multimedia learning experiences based on cognitive science research. It encompasses application of Mayer's principles, cognitive load management, and media selection to create engaging and effective learning content.

## Capabilities

### Mayer's Principles Application
- Multimedia principle (words and graphics)
- Contiguity principle (spatial and temporal)
- Modality principle (audio and graphics)
- Redundancy principle (avoid duplication)
- Coherence principle (remove extraneous)

### Cognitive Load Management
- Manage intrinsic load
- Minimize extraneous load
- Optimize germane load
- Segment complex content
- Pre-train on key concepts

### Media Selection
- Choose appropriate media types
- Balance visual and auditory channels
- Design effective graphics
- Create purposeful animations
- Integrate video appropriately

### Design Application
- Apply signaling techniques
- Design for personalization
- Use voice appropriately
- Create effective visuals
- Ensure accessibility

## Usage Guidelines

### Design Process
1. Analyze learning content
2. Assess cognitive demands
3. Select appropriate media
4. Apply design principles
5. Review and iterate
6. Test with learners

### Principle Application Guidelines
- Present words and graphics together
- Place text near related graphics
- Use audio with graphics (not redundant text)
- Remove non-essential content
- Segment complex information

### Quality Criteria
- Supports learning objectives
- Reduces unnecessary cognitive load
- Engages appropriate channels
- Maintains learner attention
- Meets accessibility standards

## Integration Points

### Related Processes
- E-Learning Course Authoring
- UDL Implementation
- SAM Model Implementation

### Collaborating Skills
- elearning-storyboarding
- instructional-video-production
- accessibility-compliance-auditing

## References

- Mayer's multimedia learning research
- Cognitive load theory (Sweller)
- Clark and Mayer e-learning principles
- Universal design for learning
