---
name: network-visualizer
description: Skill for visualizing network and graph data
allowed-tools:
  - Bash
  - Read
  - Write
metadata:
  specialization: scientific-discovery
  domain: science
  category: Visualization
  skill-id: SK-SCIDISC-022
---

# Network Visualizer Skill

## Purpose

Visualize network and graph data for exploring relationships, communities, and structural patterns in complex systems.

## Capabilities

- Layout network graphs
- Detect communities
- Highlight node attributes
- Calculate centrality
- Animate dynamics
- Export visualizations

## Usage Guidelines

1. Import network data
2. Select layout algorithm
3. Configure styling
4. Apply analysis overlays
5. Refine visualization
6. Export results

## Process Integration

Works within scientific discovery workflows for:
- Citation network analysis
- Social network visualization
- Biological pathway display
- Relationship exploration

## Configuration

- Layout algorithms
- Node/edge styling
- Analysis overlays
- Export options

## Output Artifacts

- Network visualizations
- Community maps
- Centrality highlights
- Interactive graphs
