---
name: nvh-analysis
description: Noise, vibration, and harshness analysis and optimization expertise
allowed-tools:
  - Read
  - Write
  - Glob
  - Grep
  - Edit
  - WebFetch
  - WebSearch
  - Bash
metadata:
  version: "1.0"
  category: automotive-engineering
  tags:
    - testing
    - nvh
    - acoustics
    - vibration
---

# NVH Analysis Skill

## Purpose
Provide noise, vibration, and harshness analysis and optimization expertise for vehicle refinement and sound quality engineering.

## Capabilities
- Modal analysis and transfer path analysis
- Order tracking and Campbell diagrams
- Source-path-receiver analysis
- Panel contribution analysis
- Acoustic simulation (SEA, BEM, FEM)
- Sound quality metrics
- EV/HEV-specific NVH (inverter whine, motor noise)
- Pass-by noise simulation

## Usage Guidelines
- Identify NVH sources through transfer path analysis
- Use order tracking for rotating component analysis
- Apply acoustic simulation for early design guidance
- Evaluate sound quality for brand character
- Address EV-specific noise sources
- Validate against pass-by noise regulations

## Dependencies
- Siemens LMS Test.Lab
- HEAD acoustics
- MATLAB

## Process Integration
- PTE-002: Electric Drive Unit Development
- VDC-001: Suspension System Development
- TVL-001: Vehicle-Level Validation Testing
