---
name: okr-skill
description: OKR methodology expertise including objective setting, key results definition, quarterly cadences, and alignment cascading
allowed-tools:
  - Read
  - Write
  - Glob
  - Grep
  - Edit
metadata:
  specialization: business-strategy-advanced
  domain: business
  category: strategy-execution
  phase: 6
---

# OKR Skill

## Overview

The OKR (Objectives and Key Results) Skill provides comprehensive expertise in implementing and managing the OKR goal-setting framework. This skill encompasses the complete OKR lifecycle from objective formulation through key results tracking, including alignment cascading, quarterly cadences, and continuous improvement practices. Based on methodologies pioneered at Intel and popularized by Google, this skill enables organizations to create focus, alignment, and transparency around their most important goals.

## Capabilities

### Objective Formulation
- Craft inspiring, qualitative objectives that answer "What do we want to achieve?"
- Apply the "Newspaper Test" - objectives should be exciting and meaningful
- Distinguish between committed OKRs (must achieve) and aspirational OKRs (stretch goals)
- Create objectives that are ambitious yet achievable (moonshot thinking)
- Ensure objectives are time-bound and action-oriented
- Balance between company, team, and individual objectives
- Apply CRAFT criteria: Create alignment, Refine focus, Amplify momentum, Foster transparency, Track progress

### Key Results Definition
- Define measurable, quantitative key results that answer "How will we know we achieved it?"
- Apply SMART criteria adapted for OKRs (Specific, Measurable, Achievable, Relevant, Time-bound)
- Distinguish between input metrics, output metrics, and outcome metrics
- Create 3-5 key results per objective for optimal focus
- Set appropriate scoring scales (typically 0.0 to 1.0)
- Define clear success criteria and measurement methodologies
- Balance leading and lagging indicators
- Avoid "binary" or "milestone" key results when possible

### OKR Alignment and Cascading
- Design vertical alignment from company to team to individual OKRs
- Create horizontal alignment across teams and departments
- Apply "bowling lane" model for autonomous team OKRs
- Balance top-down direction with bottom-up innovation (60/40 rule)
- Identify dependencies and shared OKRs across teams
- Map contribution relationships between OKR levels
- Ensure strategic coherence without micromanagement

### Quarterly Cadence Management
- Design effective OKR cycles (typically quarterly)
- Facilitate quarterly OKR planning sessions
- Structure mid-quarter check-ins and reviews
- Lead end-of-quarter scoring and reflection sessions
- Manage OKR rollover and continuation decisions
- Coordinate annual strategic OKRs with quarterly operational OKRs
- Balance stability with flexibility for changing priorities

### OKR Scoring and Grading
- Apply consistent 0.0-1.0 scoring methodology
- Interpret scores: 0.7-1.0 = Green (on track), 0.4-0.6 = Yellow (needs attention), 0.0-0.3 = Red (at risk)
- Analyze patterns in scoring across teams and time periods
- Distinguish between failure due to poor execution vs. ambitious goal-setting
- Use scores for learning, not punishment
- Aggregate and report OKR progress at multiple levels
- Calculate confidence levels during cycle

### OKR Integration with Strategy
- Connect OKRs to strategic planning and vision
- Translate strategy into actionable OKRs
- Link OKRs to Balanced Scorecard perspectives
- Integrate with strategic initiatives and projects
- Ensure OKRs drive strategic priorities, not just operations
- Map OKRs to strategic themes and pillars

## Methodologies

### John Doerr's OKR Framework
- Formula: "I will [Objective] as measured by [Key Results]"
- CFR (Conversations, Feedback, Recognition) continuous performance management
- Four OKR superpowers: Focus, Align, Track, Stretch
- Separating OKRs from compensation (decouple from bonuses)

### Google's OKR Approach
- Aspirational vs. Committed OKRs distinction
- 60-70% achievement target for stretch goals
- Public transparency of all OKRs
- Bottom-up contribution to company OKRs

### OKR Coaching Framework
- Weekly check-in cadence
- Confidence rating methodology
- Conversation frameworks for coaching discussions
- Celebration and recognition rituals

## Usage

### Input Requirements
- Strategic plan or vision statement
- Organizational structure and team definitions
- Current performance metrics and baselines
- Historical OKR data (if available)
- Business context and priorities

### Output Deliverables
- OKR sets (objectives with key results) at all levels
- OKR alignment maps showing connections
- Measurement plans with data sources
- Cadence calendars and review schedules
- Scoring templates and dashboards
- OKR playbooks and guidelines

### Best Practices
1. Keep objectives qualitative and inspiring
2. Limit to 3-5 objectives per level
3. Limit to 3-5 key results per objective
4. Make key results specific and measurable
5. Set challenging but achievable targets
6. Review and score consistently
7. Learn from both successes and failures
8. Maintain transparency across the organization
9. Separate OKRs from performance reviews
10. Iterate and improve the process each cycle

## Common Anti-Patterns to Avoid

- **Too many OKRs**: Loss of focus and diluted effort
- **Binary key results**: "Launch feature X" is a task, not a measurable result
- **Sandbagging**: Setting easily achievable goals to guarantee success
- **OKRs as task lists**: OKRs should be outcomes, not activities
- **Set and forget**: OKRs require regular check-ins and attention
- **Punishment for misses**: Destroys psychological safety for ambitious goals
- **Perfect alignment obsession**: Some autonomy is healthy
- **Copying others' OKRs**: OKRs must be contextual to your organization

## Integration Points

- **Strategic Planning**: OKRs operationalize strategic priorities
- **Balanced Scorecard**: OKRs can serve as tactical implementation of BSC
- **Performance Management**: OKRs inform but don't replace performance reviews
- **Project Management**: Projects deliver key results, not vice versa
- **Agile Sprints**: Sprint goals can align with quarterly OKRs

## References

- "Measure What Matters" by John Doerr
- "Radical Focus" by Christina Wodtke
- "OKRs at the Center" by Paul Niven and Ben Lamorte
- Google re:Work OKR Guide
- Doerr's OKR Playbook at whatmatters.com
