---
name: opex-program-designer
description: Operational Excellence program design skill with governance structure, methodology deployment, and capability building
allowed-tools:
  - Read
  - Write
  - Glob
  - Grep
  - Edit
metadata:
  specialization: operations
  domain: business
  category: continuous-improvement
---

# OpEx Program Designer

## Overview

The OpEx Program Designer skill provides comprehensive capabilities for designing and deploying Operational Excellence programs. It supports governance model design, methodology integration, capability maturity assessment, and sustainability mechanisms.

## Capabilities

- OpEx vision and strategy development
- Governance model design
- Methodology selection and integration
- Capability maturity assessment
- Training curriculum development
- Certification pathway design
- Deployment roadmap creation
- Sustainability mechanisms

## Used By Processes

- CI-001: Operational Excellence Program Design
- QMS-002: TQM Program Development
- LEAN-001: Value Stream Mapping

## Tools and Libraries

- Maturity assessment frameworks
- Training management systems
- Project tracking tools
- Communication platforms

## Usage

```yaml
skill: opex-program-designer
inputs:
  organization_profile:
    size: "Enterprise"
    industry: "Manufacturing"
    locations: 15
    employees: 5000
  current_state:
    methodologies_in_use: ["Lean", "5S"]
    maturity_level: "Developing"
    dedicated_resources: 5
  strategic_objectives:
    - "20% productivity improvement"
    - "50% defect reduction"
    - "30% lead time reduction"
  implementation_timeline: 36  # months
outputs:
  - opex_strategy
  - governance_model
  - methodology_framework
  - capability_roadmap
  - training_curriculum
  - certification_paths
  - deployment_plan
```

## OpEx Program Components

### Vision and Strategy
- Define OpEx vision aligned with business strategy
- Set measurable objectives
- Identify key focus areas
- Establish success metrics

### Governance Structure
- Steering committee
- Program management office
- Site champions
- Project teams

### Methodology Integration

| Methodology | Focus Area | Best For |
|-------------|------------|----------|
| Lean | Waste elimination | Flow improvement |
| Six Sigma | Variation reduction | Quality improvement |
| TOC | Constraint management | Throughput increase |
| TPM | Equipment reliability | OEE improvement |
| Agile | Flexibility | Rapid change |

## OpEx Maturity Model

| Level | Characteristics | Behaviors |
|-------|-----------------|-----------|
| 1 - Beginning | Sporadic efforts | Awareness building |
| 2 - Developing | Structured projects | Training programs |
| 3 - Performing | Systematic deployment | Results tracking |
| 4 - Leading | Culture embedded | Self-sustaining |
| 5 - Transforming | Industry benchmark | Innovation driven |

## Certification Pathways

### Lean/Six Sigma Belts
- White Belt: Awareness (4 hours)
- Yellow Belt: Participant (8-16 hours)
- Green Belt: Project leader (40-80 hours)
- Black Belt: Expert (160+ hours)
- Master Black Belt: Teacher/coach (ongoing)

## Sustainability Mechanisms

1. **Leader Standard Work** - Management routines
2. **Visual Management** - Performance transparency
3. **Recognition Programs** - Reward improvements
4. **Knowledge Management** - Share best practices
5. **Succession Planning** - Develop next generation

## Integration Points

- HR systems (training records)
- Project management systems
- Financial systems (benefit tracking)
- Communication platforms
