---
name: oral-history-interview-technique
description: Conduct life history and testimonial interviews with appropriate prompting, active listening, and trauma-informed approaches
allowed-tools: Read, Grep, Write, Edit, Glob
---

# Oral History Interview Technique

Conduct life history and testimonial interviews with appropriate prompting, active listening, and trauma-informed approaches.

## Overview

This skill enables professional oral history interviewing. It encompasses interview preparation, questioning techniques, active listening, and trauma-informed practice to collect valuable personal testimonies and life histories.

## Capabilities

### Interview Preparation
- Background research
- Question development
- Logistics planning
- Equipment setup
- Rapport building

### Questioning Techniques
- Open-ended questions
- Follow-up prompts
- Clarification requests
- Timeline establishment
- Detail elicitation

### Active Listening
- Full attention
- Non-verbal cues
- Reflective responses
- Silence tolerance
- Emotional attunement

### Trauma-Informed Practice
- Safety establishment
- Choice provision
- Pace adjustment
- Trigger awareness
- Support resources

## Usage Guidelines

### Interview Process
1. Conduct background research
2. Develop interview guide
3. Explain process to narrator
4. Obtain informed consent
5. Conduct interview
6. Thank narrator
7. Process recording

### Questioning Best Practices
- Start with context questions
- Progress chronologically
- Use open questions primarily
- Allow natural tangents
- Return to key topics

### Ethical Considerations
- Respect narrator autonomy
- Maintain confidentiality
- Honor agreements
- Provide copies
- Acknowledge contributions

## Integration Points

### Related Processes
- Oral History Collection Protocol
- Ethnographic Interview Methodology
- Participant Observation Protocol

### Collaborating Skills
- research-ethics-irb-navigation
- ethnographic-coding-thematics
- primary-source-evaluation

## References

- Oral History Association principles
- Interview methodology texts
- Trauma-informed practice guides
- Active listening techniques
