---
name: orbital-debris
description: Skill for orbital debris risk assessment and mitigation planning
allowed-tools:
  - Read
  - Write
  - Glob
  - Grep
  - Edit
  - WebFetch
  - WebSearch
  - Bash
metadata:
  version: "1.0"
  category: aerospace-engineering
  tags:
    - space-systems
    - debris
    - risk-assessment
    - compliance
---

# Orbital Debris Assessment Skill

## Purpose
Provide comprehensive orbital debris risk assessment capabilities for collision avoidance, debris mitigation compliance, and long-term orbit sustainability.

## Capabilities
- Collision probability calculation
- Debris environment modeling (ORDEM, MASTER)
- Conjunction assessment
- Collision avoidance maneuver planning
- Post-mission disposal planning
- Debris mitigation guideline compliance
- Shielding assessment
- Long-term orbit evolution

## Usage Guidelines
- Use current debris environment models for risk assessment
- Calculate collision probability for critical mission phases
- Plan avoidance maneuvers with sufficient lead time
- Design for post-mission disposal compliance
- Consider shielding for high-risk debris encounters
- Document debris mitigation measures for licensing

## Dependencies
- DAS (Debris Assessment Software)
- ORDEM
- STK

## Process Integration
- AE-017: Orbital Debris Assessment
