---
name: paraview-scientific-visualizer
description: ParaView visualization skill for 3D scientific data rendering and analysis
allowed-tools:
  - Bash
  - Read
  - Write
  - Edit
  - Glob
  - Grep
metadata:
  specialization: physics
  domain: science
  category: visualization-documentation
  phase: 6
---

# ParaView Scientific Visualizer

## Purpose

Provides expert guidance on ParaView for 3D scientific visualization, including volume rendering and animation generation.

## Capabilities

- VTK data format handling
- Volume rendering and isosurfaces
- Streamlines and glyphs
- Animation generation
- Python scripting (pvpython)
- Remote visualization

## Usage Guidelines

1. **Data Loading**: Load VTK and other scientific formats
2. **Visualization**: Create volume renders and isosurfaces
3. **Vector Fields**: Visualize with streamlines and glyphs
4. **Animation**: Generate time-series animations
5. **Scripting**: Automate with Python scripting

## Tools/Libraries

- ParaView
- VTK
- vtk-numpy-integration
