---
name: patient-safety-event-analysis
description: Investigate patient safety events using RCA, FMEA, and other systematic analysis methods to identify contributing factors and develop corrective actions
allowed-tools: Read, Grep, Write, Edit, Glob, WebFetch
---

# Patient Safety Event Analysis

Investigate patient safety events using RCA, FMEA, and other systematic analysis methods to identify contributing factors and develop corrective actions.

## Overview

This skill enables systematic analysis of patient safety events. It encompasses root cause analysis, failure mode analysis, contributing factor identification, and corrective action development to prevent recurrence and improve patient safety.

## Capabilities

### Root Cause Analysis
- Event investigation
- Timeline reconstruction
- Causal factor identification
- Contributing factor analysis
- System issue identification

### FMEA
- Process step identification
- Failure mode identification
- Severity assessment
- Occurrence probability
- Detection analysis

### Investigation Methods
- Staff interviews
- Chart review
- Process observation
- Equipment analysis
- Environmental assessment

### Corrective Actions
- Action development
- Risk mitigation
- Implementation planning
- Effectiveness monitoring
- Sustainability measures

## Usage Guidelines

### RCA Process
1. Identify and report event
2. Assemble investigation team
3. Gather information
4. Reconstruct event timeline
5. Identify contributing factors
6. Determine root causes
7. Develop corrective actions
8. Implement and monitor

### FMEA Process
1. Select process to analyze
2. Assemble multidisciplinary team
3. Map process steps
4. Identify potential failure modes
5. Score risk (RPN)
6. Prioritize actions
7. Implement improvements
8. Reassess risk

### Documentation Standards
- Comprehensive event reports
- Investigation documentation
- Action tracking logs
- Effectiveness measures
- Lessons learned

## Integration Points

### Related Processes
- Root Cause Analysis
- Patient Safety Event Reporting
- FMEA Process
- HRO Implementation

### Collaborating Skills
- quality-metrics-measurement
- clinical-workflow-analysis
- accreditation-tracer-simulation

## References

- Joint Commission RCA framework
- IHI patient safety resources
- AHRQ safety tools
- HRO principles
