---
name: payer-contract-analysis
description: Analyze payer contracts for reimbursement rates, terms, and value-based incentives to optimize revenue and support contract negotiations
allowed-tools: Read, Grep, Write, Edit, Glob, WebFetch
---

# Payer Contract Analysis

Analyze payer contracts for reimbursement rates, terms, and value-based incentives to optimize revenue and support contract negotiations.

## Overview

This skill enables analysis of healthcare payer contracts. It encompasses rate analysis, term evaluation, performance modeling, and negotiation support to optimize reimbursement and manage payer relationships effectively.

## Capabilities

### Rate Analysis
- Fee schedule comparison
- Medicare comparison
- Benchmark analysis
- Rate trending
- Service line profitability

### Term Evaluation
- Payment terms
- Authorization requirements
- Timely filing limits
- Appeal processes
- Termination provisions

### Value-Based Analysis
- Quality incentives
- Shared savings models
- Risk arrangements
- Performance metrics
- Bonus calculations

### Negotiation Support
- Contract modeling
- Proposal development
- Counter-offer analysis
- Impact assessment
- Strategic recommendations

## Usage Guidelines

### Analysis Process
1. Obtain contract documents
2. Extract key terms
3. Analyze reimbursement rates
4. Compare to benchmarks
5. Model financial impact
6. Identify opportunities
7. Develop recommendations

### Key Analysis Areas
- Base rates by service type
- Carve-outs and exclusions
- Administrative requirements
- Quality/performance terms
- Dispute resolution

### Modeling Approaches
- Current vs. proposed comparison
- Scenario analysis
- Sensitivity testing
- Break-even analysis
- Multi-year projections

## Integration Points

### Related Processes
- Claims Management Workflow
- Denial Prevention and Management
- Service Line Strategic Planning

### Collaborating Skills
- revenue-cycle-analytics
- medical-coding-audit
- quality-metrics-measurement

## References

- HFMA contract management
- Managed care negotiation guides
- Value-based contracting frameworks
- Healthcare finance standards
