---
name: peer-review-simulator
description: Skill for simulating peer review feedback on manuscripts
allowed-tools:
  - Read
  - Write
  - Bash
metadata:
  specialization: scientific-discovery
  domain: science
  category: Quality Assurance
  skill-id: SK-SCIDISC-031
---

# Peer Review Simulator Skill

## Purpose

Simulate peer review feedback on manuscripts to identify potential issues and improve quality before submission.

## Capabilities

- Analyze manuscript quality
- Identify methodological issues
- Check statistical validity
- Assess presentation clarity
- Generate reviewer comments
- Prioritize improvements

## Usage Guidelines

1. Load manuscript
2. Analyze structure
3. Review methodology
4. Check statistics
5. Generate feedback
6. Prioritize issues

## Process Integration

Works within scientific discovery workflows for:
- Pre-submission review
- Quality improvement
- Manuscript refinement
- Author preparation

## Configuration

- Review criteria
- Strictness levels
- Focus areas
- Output formats

## Output Artifacts

- Review reports
- Comment summaries
- Issue prioritization
- Improvement suggestions
