---
name: performance-test-designer
description: Performance test design skill for test planning, data collection, and acceptance criteria verification
allowed-tools:
  - Read
  - Write
  - Glob
  - Grep
  - Edit
  - Bash
metadata:
  specialization: chemical-engineering
  domain: science
  category: Commissioning
  skill-id: CE-SK-028
---

# Performance Test Designer Skill

## Purpose

The Performance Test Designer Skill develops comprehensive performance test plans including test conditions, data collection requirements, and acceptance criteria for process verification.

## Capabilities

- Test plan development
- Test condition specification
- Data collection requirements
- Instrumentation requirements
- Acceptance criteria definition
- Test duration calculation
- Statistical analysis planning
- Guarantee verification
- Report template generation

## Usage Guidelines

### When to Use
- Designing performance tests
- Verifying process guarantees
- Commissioning new equipment
- Validating modifications

### Prerequisites
- Design specifications available
- Guarantee requirements defined
- Instruments calibrated
- Steady-state achievable

### Best Practices
- Define clear acceptance criteria
- Plan adequate test duration
- Ensure instrument accuracy
- Document all conditions

## Process Integration

This skill integrates with:
- Performance Testing and Validation
- Process Startup Procedure Development
- Scale-Up Analysis

## Configuration

```yaml
performance-test-designer:
  test-types:
    - capacity
    - efficiency
    - product-quality
    - emissions
  statistical-methods:
    - uncertainty-analysis
    - ASME-PTC
```

## Output Artifacts

- Test plans
- Data collection sheets
- Analysis procedures
- Report templates
- Acceptance certificates
