---
name: population-health-stratification
description: Stratify patient populations by risk level using claims data, clinical data, and social determinants to prioritize care management interventions
allowed-tools: Read, Grep, Write, Edit, Glob, Bash, WebFetch
---

# Population Health Stratification

Stratify patient populations by risk level using claims data, clinical data, and social determinants to prioritize care management interventions.

## Overview

This skill enables risk stratification of patient populations for care management. It encompasses data analysis, risk modeling, segment identification, and intervention prioritization to target resources effectively.

## Capabilities

### Risk Assessment
- Claims-based risk scores
- Clinical risk factors
- Utilization patterns
- Social determinants
- Predictive modeling

### Data Analysis
- Multi-source integration
- Pattern identification
- Cohort analysis
- Trend tracking
- Outcome correlation

### Stratification Models
- Rising risk identification
- High-risk patient flagging
- Condition-specific cohorts
- Utilization tiers
- Intervention matching

### Resource Targeting
- Care management allocation
- Intervention prioritization
- Program matching
- Outreach planning
- Impact projection

## Usage Guidelines

### Stratification Process
1. Define population scope
2. Aggregate data sources
3. Apply risk algorithms
4. Validate stratification
5. Create patient segments
6. Match interventions
7. Monitor outcomes

### Risk Factors
- Chronic conditions
- Prior utilization
- Medication complexity
- Social needs
- Care gaps

### Intervention Matching
- High-risk: Intensive care management
- Rising-risk: Targeted outreach
- Low-risk: Wellness programs
- Condition-specific: Disease management
- Social needs: Community resources

## Integration Points

### Related Processes
- Population Health Management Program
- Clinical Pathway Development
- Service Line Strategic Planning

### Collaborating Skills
- care-transition-coordination
- clinical-workflow-analysis
- quality-metrics-measurement

## References

- Population health frameworks
- Risk stratification methodologies
- AHRQ population health tools
- ACO quality metrics
