---
name: portfolio-dashboard-builder
description: Generates portfolio dashboards with visualizations, trends
allowed-tools:
  - Read
  - Write
  - Glob
  - Grep
  - Bash
  - WebFetch
metadata:
  specialization: venture-capital
  domain: business
  skill-id: vc-skill-034
---

# Portfolio Dashboard Builder

## Overview

The Portfolio Dashboard Builder skill creates visual dashboards for portfolio monitoring and LP reporting. It generates standardized and custom visualizations to communicate portfolio performance effectively.

## Capabilities

### Dashboard Generation
- Create standardized portfolio dashboards
- Support custom dashboard configurations
- Generate multiple view types (summary, detail)
- Enable drill-down capabilities

### Visualization Creation
- Generate charts and graphs
- Create portfolio heatmaps
- Build comparison visualizations
- Support interactive elements

### Performance Tracking
- Visualize fund performance metrics
- Track company performance over time
- Compare against benchmarks
- Highlight top/bottom performers

### LP Reporting Support
- Generate LP-ready visualizations
- Support ILPA reporting formats
- Create quarterly report exhibits
- Enable export to presentations

## Usage

### Build Portfolio Dashboard
```
Input: Portfolio data, dashboard configuration
Process: Generate visualizations
Output: Complete dashboard, export files
```

### Create Custom Visualization
```
Input: Data, visualization specifications
Process: Build specified visualization
Output: Custom chart/graph
```

### Generate LP Report Exhibits
```
Input: Quarterly data, report template
Process: Create standardized exhibits
Output: LP-ready visualizations
```

### Update Existing Dashboard
```
Input: New data, existing dashboard
Process: Refresh with new data
Output: Updated dashboard
```

## Dashboard Components

| Component | Purpose |
|-----------|---------|
| Portfolio Summary | High-level fund metrics |
| Company Grid | Status by company |
| Performance Charts | Returns over time |
| Sector Analysis | Allocation views |
| Benchmark Comparison | Performance vs. benchmarks |

## Integration Points

- **Quarterly Portfolio Reporting**: Dashboard for reporting
- **Exit Readiness Assessment**: Exit-focused views
- **KPI Aggregator**: Feed data into dashboards
- **Portfolio Reporter (Agent)**: Support reporting

## Visualization Types

| Type | Use Case |
|------|----------|
| Bar Charts | Period comparisons |
| Line Charts | Trends over time |
| Heatmaps | Multi-dimensional status |
| Pie/Donut | Allocation breakdown |
| Scatter Plots | Multi-variable analysis |
| Tables | Detailed data display |

## Best Practices

1. Prioritize clarity over complexity
2. Use consistent color schemes
3. Include appropriate context
4. Enable drill-down for details
5. Optimize for audience (internal vs. LP)
