---
name: power-analysis-calculator
description: Skill for statistical power analysis and sample size calculation
allowed-tools:
  - Bash
  - Read
  - Write
metadata:
  specialization: scientific-discovery
  domain: science
  category: Experimental Design
  skill-id: SK-SCIDISC-013
---

# Power Analysis Calculator Skill

## Purpose

Calculate statistical power and required sample sizes for experimental designs to ensure adequate study power.

## Capabilities

- Calculate required sample size
- Compute statistical power
- Estimate effect sizes
- Handle multiple comparisons
- Support various designs
- Generate power curves

## Usage Guidelines

1. Specify design type
2. Define effect size
3. Set alpha and power
4. Calculate sample size
5. Generate power curves
6. Document analysis

## Process Integration

Works within scientific discovery workflows for:
- Study planning
- Grant proposals
- Protocol development
- Design optimization

## Configuration

- Statistical test selection
- Effect size specifications
- Power thresholds
- Output formatting

## Output Artifacts

- Sample size calculations
- Power analyses
- Effect size estimates
- Power curves
