---
name: production-coordination
description: Coordinate all aspects of live performance production including scheduling, technical requirements, artist contracts, venue logistics, and show documentation
allowed-tools: Read, Grep, Write, Edit, Glob, Bash
---

# Production Coordination

Coordinate all aspects of live performance production including scheduling, technical requirements, artist contracts, venue logistics, and show documentation.

## Overview

This skill provides comprehensive frameworks for coordinating live performance productions. It encompasses production scheduling, technical coordination, artist management, venue operations, and documentation to ensure successful performances across all disciplines.

## Capabilities

### Production Scheduling
- Create master production calendars
- Coordinate rehearsal schedules
- Plan load-in and strike timelines
- Manage tech and dress rehearsals
- Track production milestones

### Technical Coordination
- Compile technical riders and requirements
- Coordinate with technical departments
- Manage equipment and rental needs
- Oversee load-in and setup
- Document technical specifications

### Artist Management
- Negotiate and administer contracts
- Coordinate travel and hospitality
- Manage artist communications
- Handle visa and work permit requirements
- Ensure rider fulfillment

### Venue Operations
- Coordinate front-of-house operations
- Manage box office and ticketing
- Plan audience services
- Ensure safety and security protocols
- Handle emergency procedures

## Usage Guidelines

### Production Timeline
1. Confirm artistic program and contracts
2. Develop master production schedule
3. Compile technical requirements
4. Coordinate department preparations
5. Execute load-in and technical rehearsals
6. Manage performances
7. Complete strike and settlement

### Documentation Standards
- Maintain production books
- Create daily call sheets
- Document all communications
- Archive show reports
- Compile final production records

### Communication Protocols
- Establish clear chains of communication
- Hold regular production meetings
- Distribute schedules and updates
- Document decisions and changes
- Maintain contact lists

## Integration Points

### Related Processes
- Performance Production Process
- Stage Management Process
- Technical Production Process
- Event Planning Process

### Collaborating Skills
- risk-mitigation-planning
- stakeholder-facilitation

## References

- Stage Managers' Association guidelines
- IATSE standards and practices
- Venue management best practices
- Production management handbooks
