---
name: production-guidance
description: Provide detailed production specifications including instrumentation, arrangement, mix characteristics, effects, and era-specific production aesthetics
allowed-tools: Read, Write, Edit, WebSearch
id: SK-MAC-008
---

# Production Guidance

Provide comprehensive production specifications for AI music generation.

## Overview

This skill provides frameworks for specifying production elements that shape the overall sound. It covers instrumentation, arrangement, mix characteristics, effects processing, and era-specific production aesthetics.

## Capabilities

### Instrumentation Specification
- Define drum and percussion elements
- Specify bass characteristics
- Detail keyboard and synth sounds
- Describe guitar tones
- List additional instruments
- Balance organic vs electronic

### Arrangement Design
- Structure song sections
- Layer instrumental elements
- Create dynamic builds
- Design drops and breakdowns
- Plan instrumental hooks

### Mix Characteristics
- Define stereo width
- Specify frequency balance
- Note wet/dry balance
- Describe spatial depth
- Set loudness approach

### Effects Processing
- Specify reverb types
- Detail delay usage
- Note distortion/saturation
- Describe modulation effects
- List special effects

### Era Aesthetics
- Match decade-specific sounds
- Recreate vintage production
- Apply modern techniques
- Blend era influences

## Production Element Database

### Drum/Percussion Types
| Type | Characteristics | Era/Genre |
|------|-----------------|-----------|
| 808 | Deep kick, clap, hats | Hip-Hop, Electronic |
| Live Kit | Organic, dynamic | Rock, Pop, Jazz |
| Breakbeats | Chopped samples | D&B, Hip-Hop |
| Drum Machine | LinnDrum, TR-808, TR-909 | 80s, Electronic |
| Electronic | Programmed, precise | EDM, Pop |
| Lo-fi | Dusty, degraded | Lo-fi, Indie |
| World | Ethnic percussion | World, Fusion |

### Bass Types
| Type | Characteristics | Genre |
|------|-----------------|-------|
| 808 Sub | Deep, sine-wave | Hip-Hop, Trap |
| Synth Bass | Synthesized, various | Electronic, Pop |
| Electric (Picked) | Bright, articulate | Rock, Punk |
| Electric (Fingered) | Warm, round | R&B, Soul |
| Upright | Acoustic, woody | Jazz, Folk |
| Slap Bass | Percussive, funky | Funk, Pop |
| Moog Bass | Analog, fat | Various |

### Synth/Keys Types
| Type | Characteristics | Era/Genre |
|------|-----------------|-----------|
| Analog | Warm, organic | Various |
| FM | Bell-like, digital | 80s, Pop |
| Wavetable | Modern, evolving | EDM, Pop |
| Piano | Acoustic grand | Ballads, Jazz |
| Rhodes | Electric piano, warm | Soul, R&B |
| Wurlitzer | Bright, electric | Rock, Pop |
| Pad | Atmospheric, sustained | Ambient, Pop |
| Arp | Rhythmic pattern | Electronic |

### Guitar Tones
| Type | Characteristics | Genre |
|------|-----------------|-------|
| Clean Electric | Pure, jangly | Indie, Pop |
| Crunch | Light distortion | Rock |
| High Gain | Heavy distortion | Metal |
| Acoustic Steel | Bright, strummy | Folk, Pop |
| Acoustic Nylon | Warm, classical | Latin, Classical |
| Ambient | Reverb, delay-heavy | Post-Rock |

### Effects Reference
| Effect | Usage | Character |
|--------|-------|-----------|
| Plate Reverb | Drums, vocals | Classic, smooth |
| Hall Reverb | Strings, pads | Spacious |
| Room Reverb | Drums, guitar | Natural |
| Spring Reverb | Guitar | Surf, vintage |
| Tape Delay | Vocals, leads | Warm, rhythmic |
| Ping-Pong Delay | Synths | Wide, bouncy |
| Slapback | Vocals | Rockabilly |
| Chorus | Guitar, synths | Lush, wide |
| Flanger | Guitar, synths | Sweeping |
| Phaser | Guitar, keys | Swirling |
| Distortion | Guitar, synths | Aggressive |
| Saturation | Mix bus | Warmth |
| Compression | Various | Punch, glue |

### Era Production Characteristics
| Era | Characteristics |
|-----|-----------------|
| 1960s | Mono/early stereo, tape, minimal processing |
| 1970s | Analog warmth, live drums, multitrack |
| 1980s | Gated reverbs, synths, drum machines |
| 1990s | Grunge rawness, sampling, early digital |
| 2000s | Loudness war, digital polish, Auto-Tune |
| 2010s | Trap influences, minimal bass, side-chain |
| 2020s | Lo-fi revival, hybrid organic/electronic |

## Usage Guidelines

### Production Specification Format
```markdown
## Production

### Instrumentation
- **Drums**: [Detailed description]
- **Bass**: [Type and characteristics]
- **Keys/Synths**: [Sounds and textures]
- **Guitars**: [Types and tones]
- **Additional**: [Other elements]

### Arrangement
- **Structure**: [Verse-Chorus-etc pattern]
- **Layers**: [Instrumental layering approach]
- **Dynamics**: [Build and release strategy]

### Mix Character
- **Width**: [Stereo approach]
- **Depth**: [Front-to-back placement]
- **Frequency**: [Balance description]
- **Loudness**: [Dynamic range]

### Effects
- **Reverb**: [Types and usage]
- **Delay**: [Types and usage]
- **Modulation**: [Chorus, flanger, etc.]
- **Other**: [Special processing]

### Era Reference
- **Period**: [Decade/era]
- **Production Style**: [Characteristics]
- **Modern Updates**: [Contemporary touches]
```

### Quality Checklist
- [ ] Instrumentation is genre-appropriate
- [ ] Arrangement creates interest
- [ ] Mix vision is clear
- [ ] Effects are purposeful
- [ ] Era aesthetic is coherent

## Integration Points

### Related Skills
- SK-MAC-002 (style-specification) - Production in context
- SK-MAC-006 (genre-analysis) - Genre production norms
- SK-MAC-010 (music-prompt-engineering) - Platform formatting

### Related Agents
- AG-MAC-002 (music-producer-agent) - Primary executor

## References

- Music production handbooks
- Era-specific production analysis
- AI platform production tags
