---
name: program-evaluation
description: Design and implement formative, summative, and developmental evaluations using logic models and mixed methods
allowed-tools:
  - Read
  - Write
  - Edit
  - Grep
  - Glob
  - Bash
---

# Program Evaluation Skill

Design and implement rigorous evaluations of social programs and policy interventions using established frameworks.

## Overview

The Program Evaluation skill enables design and implementation of formative, summative, and developmental evaluations using logic models, theory of change frameworks, and mixed methods approaches for assessing program effectiveness and informing improvement.

## Capabilities

### Evaluation Design
- Formative evaluation
- Summative evaluation
- Developmental evaluation
- Impact evaluation
- Process evaluation

### Logic Models
- Theory of change development
- Input-output mapping
- Outcome identification
- Assumption articulation
- Indicator specification

### Data Collection
- Multiple data sources
- Quantitative measures
- Qualitative methods
- Mixed approaches
- Participatory methods

### Analysis and Reporting
- Outcome measurement
- Attribution assessment
- Cost-effectiveness analysis
- Stakeholder reporting
- Recommendation development

### Utilization Focus
- Stakeholder engagement
- Use identification
- Findings translation
- Recommendation implementation
- Learning facilitation

## Usage Guidelines

### When to Use
- Assessing program effectiveness
- Improving interventions
- Supporting decision-making
- Demonstrating accountability
- Building evidence base

### Best Practices
- Engage stakeholders early
- Clarify evaluation questions
- Use multiple methods
- Consider context
- Focus on utilization

### Integration Points
- Causal Inference Methods skill
- Mixed Methods Integration skill
- Policy Communication skill
- Quantitative Methods skill

## References

- Program Evaluation process
- Policy Impact Assessment process
- Cost-Benefit Analysis process
- Program Evaluation Specialist agent
